/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.BasicBinaryColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/BinaryColumnType;", "Lorg/jetbrains/exposed/sql/BasicBinaryColumnType;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "sqlType", "()Ljava/lang/String;", "value", "", "validateValueBeforeUpdate", "(Ljava/lang/Object;)V", "length", "I", "getLength", "<init>", "(I)V", "exposed-core"})
public final class BinaryColumnType
extends BasicBinaryColumnType {
    private final int length;

    public BinaryColumnType(int length) {
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().binaryType(this.length);
    }

    @Override
    public void validateValueBeforeUpdate(@Nullable Object value2) {
        if (value2 instanceof byte[] && !(((byte[])value2).length <= this.length)) {
            boolean bl = false;
            String string = "Value '" + value2 + "' can't be stored to database column because exceeds length (" + this.getLength() + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.exposed.sql.BinaryColumnType");
        }
        BinaryColumnType cfr_ignored_0 = (BinaryColumnType)object2;
        return this.length == ((BinaryColumnType)other).length;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.length;
        return result2;
    }
}

